/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import java.nio.file.Path;
import net.minecraft.SharedConstants;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlClientChunkMap;
import qouteall.imm_ptl.core.platform_specific.RequiemCompat;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;

public class O_O {
    public static boolean isDimensionalThreadingPresent = false;
    private static final BlockState obsidianState = Blocks.f_50080_.m_49966_();

    public static boolean isForge() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onPlayerChangeDimensionClient(ResourceKey<Level> from, ResourceKey<Level> to) {
        RequiemCompat.onPlayerTeleportedClient();
    }

    public static void onPlayerTravelOnServer(ServerPlayer player, ResourceKey<Level> from, ResourceKey<Level> to) {
        RequiemCompat.onPlayerTeleportedServer(player);
    }

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static boolean isObsidian(BlockState blockState) {
        return blockState == obsidianState;
    }

    public static void postClientChunkLoadEvent(LevelChunk chunk) {
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((ChunkAccess)chunk, false));
    }

    public static void postClientChunkUnloadEvent(LevelChunk chunk) {
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((ChunkAccess)chunk));
    }

    public static boolean isDedicatedServer() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static void postPortalSpawnEventForge(PortalGenInfo info) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ClientChunkCache createMyClientChunkManager(ClientLevel world, int loadDistance) {
        return new ImmPtlClientChunkMap(world, loadDistance);
    }

    public static boolean getIsPehkuiPresent() {
        return ModList.get().isLoaded("pehkui");
    }

    @Nullable
    public static String getImmPtlModInfoUrl() {
        String gameVersion = SharedConstants.m_183709_().m_132493_();
        if (O_O.isForge()) {
            return "https://qouteall.fun/immptl_info/forge-%s.json".formatted(gameVersion);
        }
        return "https://qouteall.fun/immptl_info/%s.json".formatted(gameVersion);
    }

    public static boolean isModLoadedWithinVersion(String modId, @Nullable String startVersion, @Nullable String endVersion) {
        if (ModList.get().isLoaded(modId)) {
            int i;
            ArtifactVersion version = ((ModContainer)ModList.get().getModContainerById(modId).get()).getModInfo().getVersion();
            if (startVersion != null && (i = version.compareTo((Object)new DefaultArtifactVersion(startVersion))) < 0) {
                return false;
            }
            return endVersion == null || (i = version.compareTo((Object)new DefaultArtifactVersion(endVersion))) <= 0;
        }
        return false;
    }

    @Nullable
    public static String getImmPtlVersion() {
        if (!FMLEnvironment.production) {
            return null;
        }
        return ((ModContainer)ModList.get().getModContainerById("imm_ptl_core").get()).getModInfo().getVersion().toString();
    }

    public static boolean shouldUpdateImmPtl(String latestReleaseVersion) {
        DefaultArtifactVersion latestVersion = new DefaultArtifactVersion(latestReleaseVersion);
        ArtifactVersion currentVersion = ((ModContainer)ModList.get().getModContainerById("imm_ptl_core").get()).getModInfo().getVersion();
        return latestVersion.compareTo((Object)currentVersion) < 0;
    }

    public static String getIssueLink() {
        return "https://github.com/iPortalTeam/ImmersivePortalsMod/issues";
    }

    @Nullable
    public static ResourceLocation getModIconLocation(String modid) {
        String[] parts;
        String path = ModList.get().getModContainerById(modid).flatMap(c -> c.getModInfo().getLogoFile()).orElse(null);
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("assets")) {
            path = path.substring("assets".length());
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((parts = path.split("/")).length != 2) {
            return null;
        }
        return new ResourceLocation(parts[0], parts[1]);
    }

    @Nullable
    public static String getModName(String modid) {
        return ModList.get().getModContainerById(modid).map(c -> c.getModInfo().getDisplayName()).orElse(null);
    }

    public static String getModDownloadLink() {
        return "https://www.curseforge.com/minecraft/mc-mods/immersive-portals-mod";
    }
}

